/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;

public class ScaleInterpolator
extends TransformInterpolator {
    float minimumScale;
    float maximumScale;
    private Transform3D scale = new Transform3D();
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    ScaleInterpolator() {
    }

    public ScaleInterpolator(Alpha alpha, TransformGroup transformGroup) {
        super(alpha, transformGroup);
        this.minimumScale = 0.1f;
        this.maximumScale = 1.0f;
    }

    public ScaleInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float f2, float f3) {
        super(alpha, transformGroup, transform3D);
        this.minimumScale = f2;
        this.maximumScale = f3;
    }

    public void setMinimumScale(float f2) {
        this.minimumScale = f2;
    }

    public float getMinimumScale() {
        return this.minimumScale;
    }

    public void setMaximumScale(float f2) {
        this.maximumScale = f2;
    }

    public float getMaximumScale() {
        return this.maximumScale;
    }

    public void setAxisOfScale(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfScale() {
        return this.getTransformAxis();
    }

    public void computeTransform(float f2, Transform3D transform3D) {
        double d2 = (1.0 - (double)f2) * (double)this.minimumScale + (double)(f2 * this.maximumScale);
        this.scale.set(d2);
        transform3D.mul(this.axis, this.scale);
        transform3D.mul(transform3D, this.axisInverse);
    }

    public Node cloneNode(boolean bl) {
        ScaleInterpolator scaleInterpolator = new ScaleInterpolator();
        scaleInterpolator.duplicateNode(this, bl);
        return scaleInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        ScaleInterpolator scaleInterpolator = (ScaleInterpolator)node;
        this.setMinimumScale(scaleInterpolator.getMinimumScale());
        this.setMaximumScale(scaleInterpolator.getMaximumScale());
    }
}

